//###########################################################################################
//#													     	       #
//#   POSTGRADUM.com						Libreria ValidaForm.js	            #
//#   Gua on line de Formacin			 	Version 1.0	   	   		     #
//#   http://www.postgradum.com									    #
//#   webmaster@postgradum.com								         #
//#                         									        #
//#   Aviso de Copyright:									       #
//#   El diseo, programacin, contenidos, imagenes, sonidos, videos y dems	      #
//#   informacin presentada en este sitio a traves de Internet, son propiedad     #
//#   intelectual de Rafael Loaiza Ayala y RRHHMagazine.com. Queda terminantemente  #
//#   prohibida la copia parcial o total sin la autorizacin previa, por escrito 	 #
//#   y debidamente notariada de los titulares del Copyright.			        #
//#														   #
//#   Todos los Derechos Reservados,		      					    #
//#   (c) 2001, Rafael Loaiza Ayala, Valencia, Venezuela.				     	     #
//#   (c) 2002, RRHHMagazine, SL. Barcelona. Espaa.					  	      #
//#														       #
//###########################################################################################
// ------------------------------------------------------------------------------------------
// Libreria de rutinas para validacin de Formularios
// 19/07/02 - Primera revisin una vez instalada la Libreria (Full release con pruebas)
// 09/08/02 - Ultima revisin (Full release con pruebas)
// ------------------------------------------------------------------------------------------


<!--

// Validador de cadenas simples -------------------------------------------------------------------------------------
//	   										    Revisado: 19/07/02 - Segunda revisin: 09/08/02
function ValidaString(cadena,req,lmin,lmax,titulo) {

	var Error = "";
	if (cadena.length > 0) {
		if (cadena.length < lmin) {
			Error += " ERROR !!!\n";
			Error += "La longitud del campo ";
			Error += titulo;
			Error += " es inferior al mnimo permitido.";
		} else if (cadena.length > lmax) {
			Error += " ERROR !!!\n";
			Error += "La longitud del campo ";
			Error += titulo;
			Error += " es superior al mximo permitido.";
		} else {
			valor = cadena.search(/^\w+/);
			if (valor == -1) {
				Error += " ERROR !!!\n";
				Error += "El campo ";
				Error += titulo;
				Error += " debe iniciar con algn caracter.";
			}
		}
	} else if (req == 1) {
		Error += " ERROR !!!\n";
		Error += "El campo ";
		Error += titulo;
		Error += " esta vaco y es requerido.";
	}
	if (Error != "") {
		alert(Error);
		return false;
	}

}



// Validador de Numeros ---------------------------------------------------------------------------------------------
//	   										    Revisado: 08/08/02 - Segunda revisin: 09/08/02
function ValidaNumeros(cadena,req,lmin,lmax,nmax,titulo) {

	var Error = "";
	if (cadena.length > 0) {
		if (cadena.length < lmin) {
			Error += " ERROR !!!\n";
			Error += "La longitud del campo ";
			Error += titulo;
			Error += " es inferior al mnimo permitido.";
		} else if (cadena.length > lmax) {
			Error += " ERROR !!!\n";
			Error += "La longitud del campo ";
			Error += titulo;
			Error += " es superior al mximo permitido.";
		} else if (cadena > nmax) {
			Error += " ERROR !!!\n";
			Error += "El campo ";
			Error += titulo;
			Error += " no puede ser superior a ";
			Error += nmax;
			Error += ".";
		} else {
			valor = cadena.search(/^(\d+)$/);
			if (valor == -1) {
				Error += " ERROR !!!\n";
				Error += "El campo ";
				Error += titulo;
				Error += " solo puede contener nmeros.";
			}
		}
	} else if (req == 1) {
		Error += " ERROR !!!\n";
		Error += "El campo ";
		Error += titulo;
		Error += " esta vaco y es requerido.";
	}
	if (Error != "") {
		alert(Error);
		return false;
	}

}



// Validador de cadenas especiales : Telfonos ----------------------------------------------------------------------
//	   										    Revisado: 19/07/02 - Segunda revisin: 09/08/02
function ValidaTelefono(cadena,req,lmin,lmax,titulo) {

	var Error = "";
	if (cadena.length > 0) {
		if (cadena.length < lmin) {
			Error += " ERROR !!!\n";
			Error += "La longitud del campo ";
			Error += titulo;
			Error += " es inferior al mnimo permitido.";
		} else if (cadena.length > lmax) {
			Error += " ERROR !!!\n";
			Error += "La longitud del campo ";
			Error += titulo;
			Error += " es superior al mximo permitido.";
		} else {
			valor = cadena.search(/^[0-9]{2,3}\s(\d+)$/);
			if (valor == -1) {
				Error += " ERROR !!!\n";
				Error += "El campo ";
				Error += titulo;
				Error += " debe utilizar el formato 99 9999999.";
			}
		}
	} else if (req == 1) {
		Error += " ERROR !!!\n";
		Error += "El campo ";
		Error += titulo;
		Error += " esta vaco y es requerido.";
	}
	if (Error != "") {
		alert(Error);
		return false;
	}

}



// Validador de cadenas especiales : Direcciones de Internet --------------------------------------------------------
//	   										    Revisado: 19/07/02 - Segunda revisin: 09/08/02
function ValidaURL(cadena,req,lmin,lmax,titulo) {

	var Error  = "";
	var iChars = "<>[]{}()*$#@!\\|\"'`^;, ";
	if (cadena.length > 0) {
		if (cadena.length < lmin) {
			Error += " ERROR !!!\n";
			Error += "La longitud del campo ";
			Error += titulo;
			Error += " es inferior al mnimo permitido.";
		} else if (cadena.length > lmax) {
			Error += " ERROR !!!\n";
			Error += "La longitud del campo ";
			Error += titulo;
			Error += " es superior al mximo permitido.";
		} else {
			for (var i=0; i<cadena.length; i++) {
				var caracter = "";
				if (iChars.indexOf(cadena.charAt(i)) != -1) {
					if (cadena.charAt(i) == " ") {
						caracter = "ESPACIO";
					} else {
						caracter = cadena.charAt(i);
					}
					Error += " ERROR !!!\n";
					Error += "El campo ";
					Error += titulo;
					Error += " no puede contener el caracter [";
					Error += caracter;
					Error += "].";
					i=cadena.length;
				}
			}
			if (Error == "") {
				valor = cadena.search(/^(http:\/\/)(\w+)(\.)(\w+\/+)*/);
				if (valor == -1) {
					Error += " ERROR !!!\n";
					Error += "El campo ";
					Error += titulo;
					Error += " debe utilizar el formato: http://direccin.dominio";
				}
			}
		}
	} else if (req == 1) {
		Error += " ERROR !!!\n";
		Error += "El campo ";
		Error += titulo;
		Error += " esta vaco y es requerido.";
	}
	if (Error != "") {
		alert(Error);
		return false;
	}

}



// Validador de cadenas especiales : Direcciones de E-Mail ----------------------------------------------------------
//	   										    Revisado: 19/07/02 - Segunda revisin: 09/08/02
function ValidaMail(cadena,req,lmin,lmax,titulo) {

	var Error  = "";
	var iChars = "<>[]{}()*$#?!\\/|\"'`^:;, ";
	if (cadena.length > 0) {
		if (cadena.length < lmin) {
			Error += " ERROR !!!\n";
			Error += "La longitud del campo ";
			Error += titulo;
			Error += " es inferior al mnimo permitido.";
		} else if (cadena.length > lmax) {
			Error += " ERROR !!!\n";
			Error += "La longitud del campo ";
			Error += titulo;
			Error += " es superior al mximo permitido.";
		} else {
			for (var i=0; i<cadena.length; i++) {
				var caracter = "";
				if (iChars.indexOf(cadena.charAt(i)) != -1) {
					if (cadena.charAt(i) == " ") {
						caracter = "ESPACIO";
					} else {
						caracter = cadena.charAt(i);
					}
					Error += " ERROR !!!\n";
					Error += "El campo ";
					Error += titulo;
					Error += " no puede contener el caracter [";
					Error += caracter;
					Error += "].";
					i=cadena.length;
				}
			}
			if (Error == "") {
				valor = cadena.search(/^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/);
				if (valor == -1) {
					Error += " ERROR !!!\n";
					Error += "El campo ";
					Error += titulo;
					Error += " debe utilizar el formato: cuenta@nombre.dominio";
				}
			}
		}
	} else if (req == 1) {
		Error += " ERROR !!!\n";
		Error += "El campo ";
		Error += titulo;
		Error += " esta vaco y es requerido.";
	}
	if (Error != "") {
		alert(Error);
		return false;
	}

}



// Validador de cadenas especiales : Cdigos y Claves de Acceso -----------------------------------------------------
//	   										    Revisado: 19/07/02 - Segunda revisin: 09/08/02
function ValidaClave(cadena,lmin,lmax,titulo) {

	var Error  = "";
	var iChars = "<>[]{}()@*$#&%?!\\/|\"'`^:;, ";
	if (cadena.length > 0) {
		if (cadena.length < lmin) {
			Error += " ERROR !!!\n";
			Error += "La longitud del campo ";
			Error += titulo;
			Error += " es inferior al mnimo permitido.";
		} else if (cadena.length > lmax) {
			Error += " ERROR !!!\n";
			Error += "La longitud del campo ";
			Error += titulo;
			Error += " es superior al mximo permitido.";
		} else {
			for (var i=0; i<cadena.length; i++) {
				var caracter = "";
				if (iChars.indexOf(cadena.charAt(i)) != -1) {
					if (cadena.charAt(i) == " ") {
						caracter = "ESPACIO";
					} else {
						caracter = cadena.charAt(i);
					}
					Error += " ERROR !!!\n";
					Error += "El campo ";
					Error += titulo;
					Error += " no puede contener el caracter [";
					Error += caracter;
					Error += "].";
					i=cadena.length;
				}
			}
		}
	} else {
		Error += " ERROR !!!\n";
		Error += "El campo "; 
		Error += titulo;
		Error += " esta vaco y es requerido.";
	}
	if (Error != "") {
		alert(Error);
		return false;
	}

}



// Validador de Cadenas Iguales -------------------------------------------------------------------------------------
//	   										    Revisado: 19/07/02 - Segunda revisin: 09/08/02
function SonIguales(cadena1,titulo1,cadena2,titulo2) {

	var Error = "";
	if (cadena1 != cadena2) {
		Error += " ERROR !!!\n";
		Error += "El campo ";
		Error += titulo1;
		Error += " no es igual a ";
		Error += titulo2;
		Error += ".";
	}
	if (Error != "") {
		alert(Error);
		return false;
	}

}



// Validador de selectores ------------------------------------------------------------------------------------------
//	   										    Revisado: 19/07/02 - Segunda revisin: 09/08/02
function ValidaSelector(selector,titulo) {

	var Error = "";
	if (selector.selectedIndex == 0) {
		Error += " ERROR !!!\n";
		Error += "Debe seleccionar una opcin de ";
		Error += titulo;
		Error += ".";
	}
	if (Error != "") {
		alert(Error);
		return false;
	}

}


-->
